package com.fmdxconnector

import kotlinx.serialization.Serializable
import kotlinx.serialization.EncodeDefault
import kotlinx.serialization.ExperimentalSerializationApi

// Centralized and corrected data models

@Serializable
data class RadioData(
    val freq: Double,
    val pi: String?,
    val pty: Int,
    val sig: Double? = 0.0, // Changed to nullable to prevent parse error
    val sigTop: Double? = 0.0, // Changed to nullable to prevent parse error
    val rds: Boolean,
    val st: Boolean,
    val bw: Int,
    val users: Int,
    val stForced: Boolean,
    val ant: String,
    val ta: Int,
    val tp: Int,
    val ecc: String?,
    val rt0: String?,
    val rt1: String?,
    val ps: String,
    val ps_errors: String?,
    val af: List<Int>,
    val txInfo: TxInfo?
)

@Serializable
data class TxInfo(
    val tx: String?,
    val city: String?,
    val itu: String?,
    val dist: String?,
    val azi: String?,
    val pol: String?,
    val erp: String?,
    val id: String?
)

@OptIn(ExperimentalSerializationApi::class)
@Serializable
data class ScannerCommand(
    @EncodeDefault val type: String = "Scanner",
    val value: CommandValue,
    @EncodeDefault val source: String = "TEF Logger App"
)

@OptIn(ExperimentalSerializationApi::class)
@Serializable
data class CommandValue(
    val status: String,
    @EncodeDefault val Scan: String? = null,
    @EncodeDefault val Search: String? = null,
    @EncodeDefault val password: String? = null,
    @EncodeDefault val response: String? = null
)