/*
 * Decompiled with CFR 0.152.
 */
package com.fmdxconnector.audio;

import android.net.Uri;
import android.util.Log;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.datasource.BaseDataSource;
import androidx.media3.datasource.DataSpec;
import com.fmdxconnector.LogCenter;
import com.fmdxconnector.LogLevel;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b\u0003\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\n\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J \u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020\bH\u0016J\b\u0010!\u001a\u00020\"H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/fmdxconnector/audio/WebSocketStreamDataSource;", "Landroidx/media3/datasource/BaseDataSource;", "client", "Lokhttp3/OkHttpClient;", "url", "", "userAgent", "networkBuffer", "", "<init>", "(Lokhttp3/OkHttpClient;Ljava/lang/String;Ljava/lang/String;I)V", "queue", "Ljava/util/concurrent/LinkedBlockingQueue;", "", "endMarker", "currentBuffer", "bufferPosition", "webSocket", "Lokhttp3/WebSocket;", "closed", "", "failure", "", "dataSpec", "Landroidx/media3/datasource/DataSpec;", "open", "", "getUri", "Landroid/net/Uri;", "read", "buffer", "offset", "readLength", "close", "", "app_productionNoDebug"})
@UnstableApi
@SourceDebugExtension(value={"SMAP\nAudioWebSocketPlayer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AudioWebSocketPlayer.kt\ncom/fmdxconnector/audio/WebSocketStreamDataSource\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,319:1\n1#2:320\n*E\n"})
final class WebSocketStreamDataSource
extends BaseDataSource {
    @NotNull
    private final OkHttpClient client;
    @NotNull
    private final String url;
    @NotNull
    private final String userAgent;
    @NotNull
    private final LinkedBlockingQueue<byte[]> queue;
    @NotNull
    private final byte[] endMarker;
    @Nullable
    private byte[] currentBuffer;
    private int bufferPosition;
    @Nullable
    private WebSocket webSocket;
    private boolean closed;
    @Nullable
    private Throwable failure;
    @Nullable
    private DataSpec dataSpec;

    public WebSocketStreamDataSource(@NotNull OkHttpClient client, @NotNull String url, @NotNull String userAgent, int networkBuffer) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)userAgent, (String)"userAgent");
        super(true);
        this.client = client;
        this.url = url;
        this.userAgent = userAgent;
        this.queue = new LinkedBlockingQueue(networkBuffer);
        this.endMarker = new byte[0];
    }

    public long open(@NotNull DataSpec dataSpec) {
        Intrinsics.checkNotNullParameter((Object)dataSpec, (String)"dataSpec");
        this.dataSpec = dataSpec;
        this.transferInitializing(dataSpec);
        this.transferStarted(dataSpec);
        Log.d((String)"WebSocketStreamDataSource", (String)("Opening Audio WebSocket: " + this.url));
        LogCenter.log$default(LogCenter.INSTANCE, "Opening Audio WebSocket: " + this.url, LogLevel.INFO, false, 4, null);
        Request request = new Request.Builder().url(this.url).header("User-Agent", this.userAgent + " (audio)").build();
        this.webSocket = this.client.newWebSocket(request, new WebSocketListener(this){
            final /* synthetic */ WebSocketStreamDataSource this$0;
            {
                this.this$0 = $receiver;
            }

            public void onOpen(WebSocket webSocket, Response response) {
                Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                webSocket.send(ByteString.Companion.of$default((ByteString.Companion)ByteString.Companion, (byte[])StringsKt.encodeToByteArray((String)"{\"type\":\"fallback\",\"data\":\"mp3\"}"), (int)0, (int)0, (int)3, null));
                Log.d((String)"WebSocketStreamDataSource", (String)"Audio WebSocket opened, fallback sent");
                LogCenter.log$default(LogCenter.INSTANCE, "Audio WebSocket opened", LogLevel.SUCCESS, false, 4, null);
            }

            public void onMessage(WebSocket webSocket, ByteString bytes) {
                Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
                Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
                byte[] packet = bytes.toByteArray();
                while (!WebSocketStreamDataSource.access$getQueue$p(this.this$0).offer(packet)) {
                    WebSocketStreamDataSource.access$getQueue$p(this.this$0).poll();
                }
            }

            public void onClosed(WebSocket webSocket, int code, String reason) {
                Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
                Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
                Log.d((String)"WebSocketStreamDataSource", (String)("Audio WebSocket closed: " + code + " " + reason));
                LogCenter.log$default(LogCenter.INSTANCE, "Audio WebSocket closed", LogLevel.WARNING, false, 4, null);
                while (!WebSocketStreamDataSource.access$getQueue$p(this.this$0).offer(WebSocketStreamDataSource.access$getEndMarker$p(this.this$0))) {
                    WebSocketStreamDataSource.access$getQueue$p(this.this$0).poll();
                }
            }

            public void onFailure(WebSocket webSocket, Throwable t, Response response) {
                Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                Log.e((String)"WebSocketStreamDataSource", (String)"Audio WebSocket failure", (Throwable)t);
                LogCenter.log$default(LogCenter.INSTANCE, "Audio WebSocket error", LogLevel.ERROR, false, 4, null);
                WebSocketStreamDataSource.access$setFailure$p(this.this$0, t);
                while (!WebSocketStreamDataSource.access$getQueue$p(this.this$0).offer(WebSocketStreamDataSource.access$getEndMarker$p(this.this$0))) {
                    WebSocketStreamDataSource.access$getQueue$p(this.this$0).poll();
                }
            }
        });
        return -1L;
    }

    @Nullable
    public Uri getUri() {
        DataSpec dataSpec = this.dataSpec;
        return dataSpec != null ? dataSpec.uri : null;
    }

    public int read(@NotNull byte[] buffer, int offset, int readLength) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        while (true) {
            byte[] next;
            byte[] data;
            if ((data = this.currentBuffer) != null && this.bufferPosition < data.length) {
                int toCopy = Math.min(readLength, data.length - this.bufferPosition);
                System.arraycopy(data, this.bufferPosition, buffer, offset, toCopy);
                this.bufferPosition += toCopy;
                this.bytesTransferred(toCopy);
                return toCopy;
            }
            if (this.queue.poll(100L, TimeUnit.MILLISECONDS) == null) continue;
            if (next == this.endMarker) {
                Throwable throwable = this.failure;
                if (throwable != null) {
                    Throwable it = throwable;
                    boolean bl = false;
                    throw it;
                }
                return -1;
            }
            this.currentBuffer = next;
            this.bufferPosition = 0;
        }
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            WebSocket webSocket = this.webSocket;
            if (webSocket != null) {
                webSocket.close(1000, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        while (!this.queue.offer(this.endMarker)) {
            this.queue.poll();
        }
        this.currentBuffer = null;
        this.bufferPosition = 0;
        this.transferEnded();
        Log.d((String)"WebSocketStreamDataSource", (String)("Audio DataSource closed for " + this.url));
    }

    public static final /* synthetic */ LinkedBlockingQueue access$getQueue$p(WebSocketStreamDataSource $this) {
        return $this.queue;
    }

    public static final /* synthetic */ byte[] access$getEndMarker$p(WebSocketStreamDataSource $this) {
        return $this.endMarker;
    }

    public static final /* synthetic */ void access$setFailure$p(WebSocketStreamDataSource $this, Throwable throwable) {
        $this.failure = throwable;
    }
}

