/*
 * Decompiled with CFR 0.152.
 */
package com.fmdxconnector.audio;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.media3.common.MediaItem;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.datasource.DataSource;
import androidx.media3.exoplayer.drm.DrmSessionManagerProvider;
import androidx.media3.exoplayer.source.MediaSource;
import androidx.media3.exoplayer.source.ProgressiveMediaSource;
import androidx.media3.exoplayer.upstream.LoadErrorHandlingPolicy;
import com.fmdxconnector.audio.AudioWebSocketPlayerKt;
import com.fmdxconnector.audio.WebSocketStreamDataSource;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/fmdxconnector/audio/WebSocketMediaSourceFactory;", "Landroidx/media3/exoplayer/source/MediaSource$Factory;", "client", "Lokhttp3/OkHttpClient;", "userAgent", "", "networkBuffer", "", "<init>", "(Lokhttp3/OkHttpClient;Ljava/lang/String;I)V", "setDrmSessionManagerProvider", "drmSessionManagerProvider", "Landroidx/media3/exoplayer/drm/DrmSessionManagerProvider;", "setLoadErrorHandlingPolicy", "loadErrorHandlingPolicy", "Landroidx/media3/exoplayer/upstream/LoadErrorHandlingPolicy;", "createMediaSource", "Landroidx/media3/exoplayer/source/MediaSource;", "mediaItem", "Landroidx/media3/common/MediaItem;", "getSupportedTypes", "", "app_productionNoDebug"})
@UnstableApi
@StabilityInferred(parameters=0)
public final class WebSocketMediaSourceFactory
implements MediaSource.Factory {
    @NotNull
    private final OkHttpClient client;
    @NotNull
    private final String userAgent;
    private final int networkBuffer;
    public static final int $stable = 8;

    public WebSocketMediaSourceFactory(@NotNull OkHttpClient client, @NotNull String userAgent, int networkBuffer) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)userAgent, (String)"userAgent");
        this.client = client;
        this.userAgent = userAgent;
        this.networkBuffer = networkBuffer;
    }

    @NotNull
    public MediaSource.Factory setDrmSessionManagerProvider(@NotNull DrmSessionManagerProvider drmSessionManagerProvider) {
        Intrinsics.checkNotNullParameter((Object)drmSessionManagerProvider, (String)"drmSessionManagerProvider");
        return this;
    }

    @NotNull
    public MediaSource.Factory setLoadErrorHandlingPolicy(@NotNull LoadErrorHandlingPolicy loadErrorHandlingPolicy) {
        Intrinsics.checkNotNullParameter((Object)loadErrorHandlingPolicy, (String)"loadErrorHandlingPolicy");
        return this;
    }

    @NotNull
    public MediaSource createMediaSource(@NotNull MediaItem mediaItem) {
        Intrinsics.checkNotNullParameter((Object)mediaItem, (String)"mediaItem");
        String string2 = mediaItem.mediaId;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"mediaId");
        String baseUrl = string2;
        String wsUrl = AudioWebSocketPlayerKt.access$buildWebSocketAudioUrl(baseUrl);
        DataSource.Factory dataSourceFactory = () -> WebSocketMediaSourceFactory.createMediaSource$lambda$0(this, wsUrl);
        MediaItem mediaItem2 = mediaItem.buildUpon().setUri(wsUrl).setMimeType("audio/mpeg").setLiveConfiguration(new MediaItem.LiveConfiguration.Builder().setTargetOffsetMs(50L).build()).build();
        Intrinsics.checkNotNullExpressionValue((Object)mediaItem2, (String)"build(...)");
        MediaItem richMediaItem = mediaItem2;
        ProgressiveMediaSource progressiveMediaSource = new ProgressiveMediaSource.Factory(dataSourceFactory).createMediaSource(richMediaItem);
        Intrinsics.checkNotNullExpressionValue((Object)progressiveMediaSource, (String)"createMediaSource(...)");
        return (MediaSource)progressiveMediaSource;
    }

    @NotNull
    public int[] getSupportedTypes() {
        int[] nArray = new int[]{4};
        return nArray;
    }

    private static final DataSource createMediaSource$lambda$0(WebSocketMediaSourceFactory this$0, String $wsUrl) {
        return (DataSource)new WebSocketStreamDataSource(this$0.client, $wsUrl, this$0.userAgent, this$0.networkBuffer);
    }
}

