/*
 * Decompiled with CFR 0.152.
 */
package com.fmdxconnector.audio;

import android.content.Context;
import android.util.Log;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.media3.common.MediaItem;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.exoplayer.DefaultLoadControl;
import androidx.media3.exoplayer.ExoPlayer;
import androidx.media3.exoplayer.LoadControl;
import androidx.media3.exoplayer.source.MediaSource;
import com.fmdxconnector.LogCenter;
import com.fmdxconnector.LogLevel;
import com.fmdxconnector.audio.AudioWebSocketPlayerKt;
import com.fmdxconnector.audio.WebSocketMediaSourceFactory;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\rR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0013"}, d2={"Lcom/fmdxconnector/audio/AudioWebSocketPlayer;", "", "<init>", "()V", "player", "Landroidx/media3/exoplayer/ExoPlayer;", "client", "Lokhttp3/OkHttpClient;", "getClient", "()Lokhttp3/OkHttpClient;", "client$delegate", "Lkotlin/Lazy;", "start", "", "context", "Landroid/content/Context;", "baseUrl", "", "stop", "app_productionNoDebug"})
@UnstableApi
@StabilityInferred(parameters=0)
public final class AudioWebSocketPlayer {
    @NotNull
    public static final AudioWebSocketPlayer INSTANCE = new AudioWebSocketPlayer();
    @Nullable
    private static ExoPlayer player;
    @NotNull
    private static final Lazy client$delegate;
    public static final int $stable;

    private AudioWebSocketPlayer() {
    }

    private final OkHttpClient getClient() {
        Lazy lazy = client$delegate;
        return (OkHttpClient)lazy.getValue();
    }

    public final synchronized void start(@NotNull Context context, @NotNull String baseUrl) {
        ExoPlayer exo;
        ExoPlayer exoPlayer;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        this.stop();
        Context appContext = context.getApplicationContext();
        String wsUrl = AudioWebSocketPlayerKt.access$buildWebSocketAudioUrl(baseUrl);
        Log.d((String)"AudioWebSocketPlayer", (String)("Audio starting for baseUrl=" + baseUrl + ", wsUrl=" + wsUrl));
        LogCenter.log$default(LogCenter.INSTANCE, "Audio started", LogLevel.SUCCESS, false, 4, null);
        WebSocketMediaSourceFactory factory = new WebSocketMediaSourceFactory(this.getClient(), "FMDXConnector", 16);
        MediaItem mediaItem = new MediaItem.Builder().setMediaId(baseUrl).build();
        Intrinsics.checkNotNullExpressionValue((Object)mediaItem, (String)"build(...)");
        MediaItem mediaItem2 = mediaItem;
        MediaSource mediaSource = factory.createMediaSource(mediaItem2);
        DefaultLoadControl defaultLoadControl = new DefaultLoadControl.Builder().setBufferDurationsMs(150, 300, 50, 100).build();
        Intrinsics.checkNotNullExpressionValue((Object)defaultLoadControl, (String)"build(...)");
        DefaultLoadControl loadControl = defaultLoadControl;
        ExoPlayer $this$start_u24lambda_u241 = exoPlayer = new ExoPlayer.Builder(appContext).setLoadControl((LoadControl)loadControl).build();
        boolean bl = false;
        $this$start_u24lambda_u241.setRepeatMode(0);
        $this$start_u24lambda_u241.setMediaSource(mediaSource);
        $this$start_u24lambda_u241.prepare();
        $this$start_u24lambda_u241.setPlayWhenReady(true);
        ExoPlayer exoPlayer2 = exoPlayer;
        Intrinsics.checkNotNullExpressionValue((Object)exoPlayer2, (String)"apply(...)");
        player = exo = exoPlayer2;
        Log.d((String)"AudioWebSocketPlayer", (String)("Audio started for baseUrl=" + baseUrl));
    }

    public final synchronized void stop() {
        if (player != null) {
            LogCenter.log$default(LogCenter.INSTANCE, "Audio stopped", LogLevel.WARNING, false, 4, null);
        }
        ExoPlayer exoPlayer = player;
        if (exoPlayer != null) {
            ExoPlayer $this$stop_u24lambda_u242 = exoPlayer;
            boolean bl = false;
            try {
                $this$stop_u24lambda_u242.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                $this$stop_u24lambda_u242.release();
            }
            catch (Exception exception) {
            }
        }
        player = null;
        Log.d((String)"AudioWebSocketPlayer", (String)"Audio stopped");
    }

    private static final OkHttpClient client_delegate$lambda$0() {
        return new OkHttpClient.Builder().readTimeout(0L, TimeUnit.MILLISECONDS).build();
    }

    static {
        client$delegate = LazyKt.lazy(AudioWebSocketPlayer::client_delegate$lambda$0);
        $stable = 8;
    }
}

