/*
 * Decompiled with CFR 0.152.
 */
package com.fmdxconnector;

import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.core.content.ContextCompat;
import androidx.lifecycle.AndroidViewModel;
import com.fmdxconnector.HostState;
import com.fmdxconnector.LogEntry;
import com.fmdxconnector.LogLevel;
import com.fmdxconnector.MainUiState;
import com.fmdxconnector.NetworkService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 42\u00020\u0001:\u00014B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u0018H\u0002J\u0006\u0010\u001a\u001a\u00020\u0018J\u0016\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u0014J\u000e\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u0010J\u0016\u0010\u001f\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\u0014J\u0016\u0010!\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020\u0014J\u000e\u0010#\u001a\u00020\u00182\u0006\u0010$\u001a\u00020%J\u0010\u0010&\u001a\u00020\u00182\u0006\u0010$\u001a\u00020%H\u0002J\u0006\u0010'\u001a\u00020\u0018J\u001e\u0010*\u001a\u00020\u00182\u0006\u0010+\u001a\u00020\u00142\u0006\u0010,\u001a\u00020-2\u0006\u0010\u001c\u001a\u00020\u0010J\u001a\u0010.\u001a\u00020\u00182\u0006\u0010/\u001a\u00020\u00142\b\b\u0002\u00100\u001a\u000201H\u0002J\u000e\u00102\u001a\u00020\u00182\u0006\u00103\u001a\u00020\u0010R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/fmdxconnector/MainViewModel;", "Landroidx/lifecycle/AndroidViewModel;", "application", "Landroid/app/Application;", "<init>", "(Landroid/app/Application;)V", "prefs", "Landroid/content/SharedPreferences;", "_uiState", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/fmdxconnector/MainUiState;", "uiState", "Lkotlinx/coroutines/flow/StateFlow;", "getUiState", "()Lkotlinx/coroutines/flow/StateFlow;", "nextHostId", "", "timeFormat", "Ljava/text/SimpleDateFormat;", "lastLogMessage", "", "lastLogTime", "", "saveHostsToPrefs", "", "loadHostsFromPrefs", "addHost", "onServerNameChanged", "hostId", "newName", "deleteHost", "onAddressChanged", "newAddress", "onAdminPasswordChanged", "newPassword", "connectToHost", "host", "Lcom/fmdxconnector/HostState;", "startConnection", "disconnectAll", "lastTextSocketLogTime", "lastPluginSocketLogTime", "updateLedState", "socketName", "isConnected", "", "addGlobalLog", "message", "level", "Lcom/fmdxconnector/LogLevel;", "setActiveHost", "id", "Companion", "app_productionNoDebug"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nMainViewModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MainViewModel.kt\ncom/fmdxconnector/MainViewModel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,278:1\n1#2:279\n1557#3:280\n1628#3,3:281\n774#3:284\n865#3,2:285\n1557#3:287\n1628#3,3:288\n1557#3:291\n1628#3,3:292\n360#3,7:295\n*S KotlinDebug\n*F\n+ 1 MainViewModel.kt\ncom/fmdxconnector/MainViewModel\n*L\n118#1:280\n118#1:281,3\n131#1:284\n131#1:285,2\n144#1:287\n144#1:288,3\n152#1:291\n152#1:292,3\n164#1:295,7\n*E\n"})
public final class MainViewModel
extends AndroidViewModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SharedPreferences prefs;
    @NotNull
    private final MutableStateFlow<MainUiState> _uiState;
    @NotNull
    private final StateFlow<MainUiState> uiState;
    private int nextHostId;
    @NotNull
    private final SimpleDateFormat timeFormat;
    @Nullable
    private String lastLogMessage;
    private long lastLogTime;
    private long lastTextSocketLogTime;
    private long lastPluginSocketLogTime;
    public static final int $stable = 8;
    @NotNull
    public static final String PREFS_NAME = "fmdx_prefs";
    @NotNull
    public static final String HOSTS_KEY = "saved_hosts";
    @NotNull
    private static final MutableSharedFlow<Pair<String, String>> logFlow = SharedFlowKt.MutableSharedFlow$default((int)100, (int)0, null, (int)6, null);

    public MainViewModel(@NotNull Application application) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        super(application);
        SharedPreferences sharedPreferences = application.getSharedPreferences(PREFS_NAME, 0);
        Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"getSharedPreferences(...)");
        this.prefs = sharedPreferences;
        this._uiState = StateFlowKt.MutableStateFlow((Object)new MainUiState(CollectionsKt.emptyList(), null, false, false, null, 30, null));
        this.uiState = FlowKt.asStateFlow(this._uiState);
        this.nextHostId = 1;
        this.timeFormat = new SimpleDateFormat("HH:mm:ss", Locale.getDefault());
        NetworkService.Companion.setLogFlow(logFlow);
        this.loadHostsFromPrefs();
    }

    @NotNull
    public final StateFlow<MainUiState> getUiState() {
        return this.uiState;
    }

    private final void saveHostsToPrefs() {
        JSONArray jsonArray = new JSONArray();
        for (HostState host : ((MainUiState)this._uiState.getValue()).getHosts()) {
            JSONObject jSONObject;
            JSONObject $this$saveHostsToPrefs_u24lambda_u240 = jSONObject = new JSONObject();
            boolean bl = false;
            $this$saveHostsToPrefs_u24lambda_u240.put("id", host.getId());
            $this$saveHostsToPrefs_u24lambda_u240.put("address", (Object)host.getAddress());
            $this$saveHostsToPrefs_u24lambda_u240.put("adminPassword", (Object)host.getAdminPassword());
            $this$saveHostsToPrefs_u24lambda_u240.put("serverName", (Object)host.getServerName());
            JSONObject obj = jSONObject;
            jsonArray.put((Object)obj);
        }
        this.prefs.edit().putString(HOSTS_KEY, jsonArray.toString()).apply();
    }

    private final void loadHostsFromPrefs() {
        String json = this.prefs.getString(HOSTS_KEY, null);
        if (json == null) {
            HostState initialHost = new HostState(1, "", "", "");
            this._uiState.setValue((Object)MainUiState.copy$default((MainUiState)this._uiState.getValue(), CollectionsKt.listOf((Object)initialHost), null, false, false, null, 30, null));
            this.nextHostId = 2;
            this.saveHostsToPrefs();
            return;
        }
        try {
            Comparable comparable;
            JSONArray array2 = new JSONArray(json);
            List loadedHosts = new ArrayList();
            int n = array2.length();
            for (int i = 0; i < n; ++i) {
                JSONObject obj = array2.getJSONObject(i);
                int n2 = obj.getInt("id");
                String string2 = obj.getString("address");
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
                String string3 = obj.optString("adminPassword", obj.optString("scanKey", ""));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"optString(...)");
                String string4 = obj.optString("serverName", "");
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"optString(...)");
                loadedHosts.add(new HostState(n2, string2, string3, string4));
            }
            this._uiState.setValue((Object)MainUiState.copy$default((MainUiState)this._uiState.getValue(), loadedHosts, null, false, false, null, 30, null));
            Iterable iterable = loadedHosts;
            MainViewModel mainViewModel = this;
            Iterator iterator = iterable.iterator();
            if (!iterator.hasNext()) {
                comparable = null;
            } else {
                HostState it = (HostState)iterator.next();
                boolean bl = false;
                Comparable comparable2 = Integer.valueOf(it.getId());
                while (iterator.hasNext()) {
                    HostState it2 = (HostState)iterator.next();
                    $i$a$-maxOfOrNull-MainViewModel$loadHostsFromPrefs$1 = false;
                    Comparable comparable3 = Integer.valueOf(it2.getId());
                    if (comparable2.compareTo(comparable3) >= 0) continue;
                    comparable2 = comparable3;
                }
                comparable = comparable2;
            }
            Integer n3 = (Integer)comparable;
            mainViewModel.nextHostId = (n3 != null ? n3 : 0) + 1;
        }
        catch (Exception e) {
            this.addGlobalLog("Error loading hosts: " + e.getMessage(), LogLevel.ERROR);
        }
    }

    public final void addHost() {
        HostState newHost = new HostState(this.nextHostId, "", "", "");
        int n = this.nextHostId;
        this.nextHostId = n + 1;
        this._uiState.setValue((Object)MainUiState.copy$default((MainUiState)this._uiState.getValue(), CollectionsKt.plus((Collection)((MainUiState)this._uiState.getValue()).getHosts(), (Object)newHost), null, false, false, null, 30, null));
        this.addGlobalLog("Server added", LogLevel.SUCCESS);
        this.saveHostsToPrefs();
    }

    /*
     * WARNING - void declaration
     */
    public final void onServerNameChanged(int hostId, @NotNull String newName) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        Iterable $this$map$iv = ((MainUiState)this._uiState.getValue()).getHosts();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void host;
            HostState hostState = (HostState)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(host.getId() == hostId ? HostState.copy$default((HostState)host, 0, null, null, newName, 7, null) : host);
        }
        List newHosts = (List)destination$iv$iv;
        this._uiState.setValue((Object)MainUiState.copy$default((MainUiState)this._uiState.getValue(), newHosts, null, false, false, null, 30, null));
        this.saveHostsToPrefs();
    }

    /*
     * WARNING - void declaration
     */
    public final void deleteHost(int hostId) {
        void $this$filterTo$iv$iv;
        Integer n = ((MainUiState)this._uiState.getValue()).getActiveHostId();
        int n2 = hostId;
        if (n != null && n == n2) {
            this.addGlobalLog("Disconnecting from server...", LogLevel.INFO);
            this.disconnectAll();
        }
        Iterable $this$filter$iv = ((MainUiState)this._uiState.getValue()).getHosts();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            HostState it = (HostState)element$iv$iv;
            boolean bl = false;
            if (!(it.getId() != hostId)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List newHosts = (List)destination$iv$iv;
        Integer n3 = ((MainUiState)this._uiState.getValue()).getActiveHostId();
        int n4 = hostId;
        Integer n5 = n3 != null && n3 == n4 ? null : ((MainUiState)this._uiState.getValue()).getActiveHostId();
        Integer n6 = ((MainUiState)this._uiState.getValue()).getActiveHostId();
        n4 = hostId;
        boolean bl = n6 != null && n6 == n4 ? false : ((MainUiState)this._uiState.getValue()).getTextConnected();
        Integer n7 = ((MainUiState)this._uiState.getValue()).getActiveHostId();
        n4 = hostId;
        this._uiState.setValue((Object)MainUiState.copy$default((MainUiState)this._uiState.getValue(), newHosts, n5, bl, n7 != null && n7 == n4 ? false : ((MainUiState)this._uiState.getValue()).getPluginsConnected(), null, 16, null));
        this.addGlobalLog("Server deleted", LogLevel.SUCCESS);
        this.saveHostsToPrefs();
    }

    /*
     * WARNING - void declaration
     */
    public final void onAddressChanged(int hostId, @NotNull String newAddress) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)newAddress, (String)"newAddress");
        Iterable $this$map$iv = ((MainUiState)this._uiState.getValue()).getHosts();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void host;
            HostState hostState = (HostState)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(host.getId() == hostId ? HostState.copy$default((HostState)host, 0, newAddress, null, null, 13, null) : host);
        }
        List newHosts = (List)destination$iv$iv;
        this._uiState.setValue((Object)MainUiState.copy$default((MainUiState)this._uiState.getValue(), newHosts, null, false, false, null, 30, null));
        this.saveHostsToPrefs();
    }

    /*
     * WARNING - void declaration
     */
    public final void onAdminPasswordChanged(int hostId, @NotNull String newPassword) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)newPassword, (String)"newPassword");
        Iterable $this$map$iv = ((MainUiState)this._uiState.getValue()).getHosts();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void host;
            HostState hostState = (HostState)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(host.getId() == hostId ? HostState.copy$default((HostState)host, 0, null, newPassword, null, 11, null) : host);
        }
        List newHosts = (List)destination$iv$iv;
        this._uiState.setValue((Object)MainUiState.copy$default((MainUiState)this._uiState.getValue(), newHosts, null, false, false, null, 30, null));
        this.saveHostsToPrefs();
    }

    public final void connectToHost(@NotNull HostState host) {
        Intent intent;
        int n;
        Application ctx;
        block2: {
            List<HostState> currentHosts;
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            ctx = this.getApplication();
            List<HostState> $this$indexOfFirst$iv = currentHosts = ((MainUiState)this._uiState.getValue()).getHosts();
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<HostState> iterator = $this$indexOfFirst$iv.iterator();
            while (iterator.hasNext()) {
                HostState item$iv;
                HostState it = item$iv = iterator.next();
                boolean bl = false;
                if (it.getId() == host.getId()) {
                    n = index$iv;
                    break block2;
                }
                ++index$iv;
            }
            n = -1;
        }
        int serverIndex = RangesKt.coerceAtLeast((int)n, (int)0);
        Intent $this$connectToHost_u24lambda_u247 = intent = new Intent((Context)ctx, NetworkService.class);
        boolean bl = false;
        $this$connectToHost_u24lambda_u247.putExtra("HOST_ADDRESS", host.getAddress());
        $this$connectToHost_u24lambda_u247.putExtra("ADMIN_PASSWORD", host.getAdminPassword());
        $this$connectToHost_u24lambda_u247.putExtra("ACTIVE_HOST_ID", host.getId());
        $this$connectToHost_u24lambda_u247.putExtra("ACTIVE_SERVER_INDEX", serverIndex);
        Intent intent2 = intent;
        ContextCompat.startForegroundService((Context)((Context)ctx), (Intent)intent2);
        this._uiState.setValue((Object)MainUiState.copy$default((MainUiState)this._uiState.getValue(), null, host.getId(), false, false, null, 29, null));
    }

    private final void startConnection(HostState host) {
        Intent intent;
        if (StringsKt.isBlank((CharSequence)host.getAddress())) {
            this.addGlobalLog("Host address is empty, cannot connect.", LogLevel.WARNING);
            return;
        }
        this._uiState.setValue((Object)MainUiState.copy$default((MainUiState)this._uiState.getValue(), null, host.getId(), false, false, null, 29, null));
        this.addGlobalLog("Connecting to " + host.getAddress() + "...", LogLevel.INFO);
        Application context = this.getApplication();
        Intent $this$startConnection_u24lambda_u248 = intent = new Intent((Context)context, NetworkService.class);
        boolean bl = false;
        $this$startConnection_u24lambda_u248.putExtra("HOST_ADDRESS", host.getAddress());
        $this$startConnection_u24lambda_u248.putExtra("ADMIN_PASSWORD", host.getAdminPassword());
        $this$startConnection_u24lambda_u248.putExtra("ACTIVE_HOST_ID", host.getId());
        Intent intent2 = intent;
        try {
            ContextCompat.startForegroundService((Context)((Context)context), (Intent)intent2);
            this.addGlobalLog("NetworkService started for " + host.getAddress(), LogLevel.SUCCESS);
        }
        catch (Exception e) {
            this.addGlobalLog("ERROR starting service: " + e.getMessage(), LogLevel.ERROR);
            this._uiState.setValue((Object)MainUiState.copy$default((MainUiState)this._uiState.getValue(), null, null, false, false, null, 29, null));
        }
    }

    public final void disconnectAll() {
        Application context = this.getApplication();
        context.stopService(new Intent((Context)context, NetworkService.class));
        if (((MainUiState)this._uiState.getValue()).getActiveHostId() != null) {
            this.addGlobalLog("All connections closed", LogLevel.INFO);
            this._uiState.setValue((Object)MainUiState.copy$default((MainUiState)this._uiState.getValue(), null, null, false, false, null, 17, null));
        }
    }

    public final void updateLedState(@NotNull String socketName, boolean isConnected, int hostId) {
        Intrinsics.checkNotNullParameter((Object)socketName, (String)"socketName");
        MainUiState current = (MainUiState)this._uiState.getValue();
        if (Intrinsics.areEqual((Object)socketName, (Object)"text") && current.getTextConnected() == isConnected) {
            return;
        }
        if (Intrinsics.areEqual((Object)socketName, (Object)"data_plugins") && current.getPluginsConnected() == isConnected) {
            return;
        }
        boolean newTextConnected = Intrinsics.areEqual((Object)socketName, (Object)"text") ? isConnected : current.getTextConnected();
        boolean newPluginsConnected = Intrinsics.areEqual((Object)socketName, (Object)"data_plugins") ? isConnected : current.getPluginsConnected();
        Integer newActiveHostId = newTextConnected || newPluginsConnected ? Integer.valueOf(hostId) : null;
        this._uiState.setValue((Object)MainUiState.copy$default(current, null, newActiveHostId, newTextConnected, newPluginsConnected, null, 17, null));
        long now = System.currentTimeMillis();
        String string2 = socketName;
        if (Intrinsics.areEqual((Object)string2, (Object)"text")) {
            if (now - this.lastTextSocketLogTime >= 1000L) {
                this.addGlobalLog("WebSocket 'text' " + (isConnected ? "connected" : "disconnected"), isConnected ? LogLevel.SUCCESS : LogLevel.WARNING);
                this.lastTextSocketLogTime = now;
            }
        } else if (Intrinsics.areEqual((Object)string2, (Object)"data_plugins") && now - this.lastPluginSocketLogTime >= 1000L) {
            this.addGlobalLog("WebSocket 'data_plugins' " + (isConnected ? "connected" : "disconnected"), isConnected ? LogLevel.SUCCESS : LogLevel.WARNING);
            this.lastPluginSocketLogTime = now;
        }
    }

    private final void addGlobalLog(String message, LogLevel level) {
        long now = System.currentTimeMillis();
        if (Intrinsics.areEqual((Object)message, (Object)this.lastLogMessage) && now - this.lastLogTime < 1000L) {
            return;
        }
        this.lastLogMessage = message;
        this.lastLogTime = now;
        String timestamp = this.timeFormat.format(new Date());
        Intrinsics.checkNotNull((Object)timestamp);
        LogEntry logEntry = new LogEntry(timestamp, level, message);
        List newGlobalLogs = CollectionsKt.takeLast((List)CollectionsKt.plus((Collection)((MainUiState)this._uiState.getValue()).getGlobalLogs(), (Object)logEntry), (int)100);
        this._uiState.setValue((Object)MainUiState.copy$default((MainUiState)this._uiState.getValue(), null, null, false, false, newGlobalLogs, 15, null));
    }

    static /* synthetic */ void addGlobalLog$default(MainViewModel mainViewModel, String string2, LogLevel logLevel, int n, Object object) {
        if ((n & 2) != 0) {
            logLevel = LogLevel.INFO;
        }
        mainViewModel.addGlobalLog(string2, logLevel);
    }

    public final void setActiveHost(int id2) {
        this._uiState.setValue((Object)MainUiState.copy$default((MainUiState)this._uiState.getValue(), null, id2, false, false, null, 29, null));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R#\u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/fmdxconnector/MainViewModel$Companion;", "", "<init>", "()V", "PREFS_NAME", "", "HOSTS_KEY", "logFlow", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "Lkotlin/Pair;", "getLogFlow", "()Lkotlinx/coroutines/flow/MutableSharedFlow;", "app_productionNoDebug"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MutableSharedFlow<Pair<String, String>> getLogFlow() {
            return logFlow;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

