/*
 * Decompiled with CFR 0.152.
 */
package com.fmdxconnector;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.util.Log;
import android.webkit.JavascriptInterface;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import androidx.compose.runtime.internal.StabilityInferred;
import com.fmdxconnector.GpsData;
import com.fmdxconnector.GpsStore;
import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u00002\u00020\u0001:\u00010B\u0093\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012b\b\u0002\u0010\b\u001a\\\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\u000e\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00070\t\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0018\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00062\b\b\u0002\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001b\u001a\u00020\u0007J\u0010\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u0006H\u0002J\u0010\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u0006H\u0002J\u0010\u0010\u001f\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u0006H\u0002J\u0010\u0010!\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u0006H\u0002J\b\u0010\"\u001a\u00020#H\u0002J0\u0010$\u001a\u00020\u0007*\u00020#2\b\b\u0002\u0010%\u001a\u00020&2\u0017\u0010'\u001a\u0013\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\b)H\u0082\bJ(\u0010*\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0006H\u0002J0\u0010+\u001a\u00020\u00072\u0006\u0010,\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0006H\u0002J\u0010\u0010-\u001a\u00020\u00072\u0006\u0010.\u001a\u00020&H\u0002J\u0010\u0010/\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u001aH\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000Rh\u0010\b\u001a\\\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\u000e\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00070\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/fmdxconnector/GpsWebViewHelper;", "", "context", "Landroid/content/Context;", "onLog", "Lkotlin/Function1;", "", "", "onGps", "Lkotlin/Function4;", "Lkotlin/ParameterName;", "name", "lat", "lon", "alt", "mode", "prefsName", "<init>", "(Landroid/content/Context;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function4;Ljava/lang/String;)V", "mainHandler", "Landroid/os/Handler;", "webView", "Landroid/webkit/WebView;", "start", "serverAddress", "watchMillis", "", "stop", "logI", "msg", "logW", "normalizeUrl", "raw", "normalizeHostKey", "prefs", "Landroid/content/SharedPreferences;", "edit", "commit", "", "block", "Landroid/content/SharedPreferences$Editor;", "Lkotlin/ExtensionFunctionType;", "saveGpsToPrefs", "saveGpsToPrefsForHost", "hostKey", "internalStop", "destroy", "buildInjectedJs", "GpsJsBridge", "app_productionNoDebug"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nGpsWebViewHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GpsWebViewHelper.kt\ncom/fmdxconnector/GpsWebViewHelper\n*L\n1#1,313:1\n157#1,4:314\n157#1,4:318\n*S KotlinDebug\n*F\n+ 1 GpsWebViewHelper.kt\ncom/fmdxconnector/GpsWebViewHelper\n*L\n163#1:314,4\n172#1:318,4\n*E\n"})
public final class GpsWebViewHelper {
    @NotNull
    private final Context context;
    @NotNull
    private final Function1<String, Unit> onLog;
    @NotNull
    private final Function4<String, String, String, String, Unit> onGps;
    @NotNull
    private final String prefsName;
    @NotNull
    private final Handler mainHandler;
    @Nullable
    private volatile WebView webView;
    public static final int $stable = 8;

    public GpsWebViewHelper(@NotNull Context context, @NotNull Function1<? super String, Unit> onLog, @NotNull Function4<? super String, ? super String, ? super String, ? super String, Unit> onGps, @NotNull String prefsName) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(onLog, (String)"onLog");
        Intrinsics.checkNotNullParameter(onGps, (String)"onGps");
        Intrinsics.checkNotNullParameter((Object)prefsName, (String)"prefsName");
        this.context = context;
        this.onLog = onLog;
        this.onGps = onGps;
        this.prefsName = prefsName;
        this.mainHandler = new Handler(Looper.getMainLooper());
    }

    public /* synthetic */ GpsWebViewHelper(Context context, Function1 function1, Function4 function4, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            function1 = GpsWebViewHelper::_init_$lambda$0;
        }
        if ((n & 4) != 0) {
            function4 = GpsWebViewHelper::_init_$lambda$1;
        }
        if ((n & 8) != 0) {
            string2 = "gps_cache";
        }
        this(context, (Function1<? super String, Unit>)function1, (Function4<? super String, ? super String, ? super String, ? super String, Unit>)function4, string2);
    }

    public final void start(@NotNull String serverAddress, long watchMillis) {
        Intrinsics.checkNotNullParameter((Object)serverAddress, (String)"serverAddress");
        if (this.webView != null) {
            this.logI("GPS watcher: already running, start ignored.");
            return;
        }
        String baseUrl = this.normalizeUrl(serverAddress);
        String hostKey = this.normalizeHostKey(serverAddress);
        this.logI("GPS watcher: load " + baseUrl + " (hostKey=" + hostKey + ")");
        this.mainHandler.post(() -> GpsWebViewHelper.start$lambda$9(this, baseUrl, watchMillis, hostKey));
    }

    public static /* synthetic */ void start$default(GpsWebViewHelper gpsWebViewHelper, String string2, long l, int n, Object object) {
        if ((n & 2) != 0) {
            l = 60000L;
        }
        gpsWebViewHelper.start(string2, l);
    }

    public final void stop() {
        this.mainHandler.post(() -> GpsWebViewHelper.stop$lambda$10(this));
    }

    private final void logI(String msg) {
        Log.i((String)"GpsWebViewHelper", (String)msg);
        this.onLog.invoke((Object)msg);
    }

    private final void logW(String msg) {
        Log.w((String)"GpsWebViewHelper", (String)msg);
        this.onLog.invoke((Object)msg);
    }

    private final String normalizeUrl(String raw) {
        String a = ((Object)StringsKt.trim((CharSequence)raw)).toString();
        String base = StringsKt.startsWith((String)a, (String)"http://", (boolean)true) || StringsKt.startsWith((String)a, (String)"https://", (boolean)true) ? a : (StringsKt.startsWith((String)a, (String)"ws://", (boolean)true) ? "http://" + StringsKt.removePrefix((String)a, (CharSequence)"ws://") : (StringsKt.startsWith((String)a, (String)"wss://", (boolean)true) ? "https://" + StringsKt.removePrefix((String)a, (CharSequence)"wss://") : "http://" + a));
        return StringsKt.endsWith$default((String)base, (String)"/", (boolean)false, (int)2, null) ? base : base + "/";
    }

    private final String normalizeHostKey(String raw) {
        Object object;
        String a = ((Object)StringsKt.trim((CharSequence)raw)).toString();
        String base = StringsKt.startsWith((String)a, (String)"http://", (boolean)true) || StringsKt.startsWith((String)a, (String)"https://", (boolean)true) ? a : (StringsKt.startsWith((String)a, (String)"ws://", (boolean)true) ? "http://" + StringsKt.removePrefix((String)a, (CharSequence)"ws://") : (StringsKt.startsWith((String)a, (String)"wss://", (boolean)true) ? "https://" + StringsKt.removePrefix((String)a, (CharSequence)"wss://") : "http://" + a));
        try {
            String host;
            Uri uri = Uri.parse((String)base);
            String string2 = uri.getHost();
            if (string2 == null) {
                string2 = host = a;
            }
            int port = uri.getPort() != -1 ? uri.getPort() : (Intrinsics.areEqual((Object)uri.getScheme(), (Object)"https") ? 443 : 80);
            object = host + ":" + port;
        }
        catch (Exception exception) {
            object = a;
        }
        return object;
    }

    private final SharedPreferences prefs() {
        SharedPreferences sharedPreferences = this.context.getApplicationContext().getSharedPreferences(this.prefsName, 0);
        Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"getSharedPreferences(...)");
        return sharedPreferences;
    }

    private final void edit(SharedPreferences $this$edit, boolean commit, Function1<? super SharedPreferences.Editor, Unit> block) {
        boolean $i$f$edit = false;
        SharedPreferences.Editor e = $this$edit.edit();
        Intrinsics.checkNotNull((Object)e);
        block.invoke((Object)e);
        if (commit) {
            e.commit();
        } else {
            e.apply();
        }
    }

    static /* synthetic */ void edit$default(GpsWebViewHelper $this, SharedPreferences $receiver, boolean commit, Function1 block, int n, Object object) {
        if ((n & 1) != 0) {
            commit = false;
        }
        boolean $i$f$edit = false;
        SharedPreferences.Editor e = $receiver.edit();
        Intrinsics.checkNotNull((Object)e);
        block.invoke((Object)e);
        if (commit) {
            e.commit();
        } else {
            e.apply();
        }
    }

    private final void saveGpsToPrefs(String lat, String lon, String alt, String mode) {
        SharedPreferences $receiver$iv = this.prefs();
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor e$iv = $receiver$iv.edit();
        Intrinsics.checkNotNull((Object)e$iv);
        SharedPreferences.Editor $this$saveGpsToPrefs_u24lambda_u2411 = e$iv;
        boolean bl = false;
        $this$saveGpsToPrefs_u24lambda_u2411.putString("qth_lat", lat);
        $this$saveGpsToPrefs_u24lambda_u2411.putString("qth_lon", lon);
        $this$saveGpsToPrefs_u24lambda_u2411.putString("qth_alt", alt);
        $this$saveGpsToPrefs_u24lambda_u2411.putString("qth_mode", mode);
        e$iv.apply();
    }

    private final void saveGpsToPrefsForHost(String hostKey, String lat, String lon, String alt, String mode) {
        SharedPreferences $receiver$iv = this.prefs();
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor e$iv = $receiver$iv.edit();
        Intrinsics.checkNotNull((Object)e$iv);
        SharedPreferences.Editor $this$saveGpsToPrefsForHost_u24lambda_u2412 = e$iv;
        boolean bl = false;
        $this$saveGpsToPrefsForHost_u24lambda_u2412.putString("qth_lat_" + hostKey, lat);
        $this$saveGpsToPrefsForHost_u24lambda_u2412.putString("qth_lon_" + hostKey, lon);
        $this$saveGpsToPrefsForHost_u24lambda_u2412.putString("qth_alt_" + hostKey, alt);
        $this$saveGpsToPrefsForHost_u24lambda_u2412.putString("qth_mode_" + hostKey, mode);
        e$iv.apply();
    }

    private final void internalStop(boolean destroy) {
        try {
            WebView webView = this.webView;
            if (webView != null) {
                webView.evaluateJavascript("(function(){try{window.__gpsStop&&window.__gpsStop();}catch(e){}})();", null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (destroy) {
            try {
                WebView webView = this.webView;
                if (webView != null) {
                    webView.destroy();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.webView = null;
        }
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private final String buildInjectedJs(long watchMillis) {
        return StringsKt.trimIndent((String)("\n(function(){\n  try{\n    var qthLat = localStorage.getItem('qthLatitude') || \"\";\n    var qthLon = localStorage.getItem('qthLongitude') || \"\";\n\n    window.__gpsStopped = false;\n    window.__gpsWS = null;\n    window.__gpsNoGpsTimer = null;\n\n    function sendNoGpsOnce(){\n      if (window.__gpsStopped) return;\n      Android.onNoGps(String(qthLat), String(qthLon));\n    }\n\n    // Sofortiger Push falls statische QTH vorhanden + Fallback nach 5s\n    if (qthLat || qthLon) { sendNoGpsOnce(); }\n    window.__gpsNoGpsTimer = setTimeout(sendNoGpsOnce, 5000);\n\n    window.__gpsStop = function(){\n      try { window.__gpsStopped = true; } catch(e){}\n      try { if (window.__gpsNoGpsTimer) { clearTimeout(window.__gpsNoGpsTimer); window.__gpsNoGpsTimer = null; } } catch(e){}\n      try { if (window.__gpsWS) { window.__gpsWS.close(); window.__gpsWS = null; } } catch(e){}\n    };\n\n    var loc = window.location;\n    var wsScheme = (loc.protocol === 'https:') ? 'wss://' : 'ws://';\n    var base = loc.host + loc.pathname;\n    if (!base.endsWith('/')) base += '/';\n    var wsUrl = wsScheme + base + 'data_plugins';\n\n    var ws = new WebSocket(wsUrl);\n    window.__gpsWS = ws;\n\n    ws.onmessage = function(ev){\n      if (window.__gpsStopped) return;\n      try {\n        var obj = JSON.parse(ev.data);\n        if (obj && obj.type === 'GPS' && obj.value) {\n          if (String(obj.value.status).toLowerCase() === 'active') {\n            if (window.__gpsNoGpsTimer) { clearTimeout(window.__gpsNoGpsTimer); window.__gpsNoGpsTimer = null; }\n            Android.onGps(\n              String(obj.value.lat || \"\"),\n              String(obj.value.lon || \"\"),\n              String(obj.value.alt || \"\"),\n              String(obj.value.mode || \"\")\n            );\n          }\n        }\n      } catch(e) {}\n    };\n\n    setTimeout(function(){\n      if (!window.__gpsStopped) { try { ws.close(); } catch(e){} }\n    }, " + watchMillis + ");\n  }catch(e){\n    try { Android.onNoGps(\"\"); } catch(_){}\n  }\n})();\n"));
    }

    private static final Unit _init_$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(String string2, String string3, String string4, String string5) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)string3, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)string4, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)string5, (String)"<unused var>");
        return Unit.INSTANCE;
    }

    private static final Unit start$lambda$9$lambda$7$lambda$2(GpsWebViewHelper this$0, String la, String lo, String al, String md) {
        Intrinsics.checkNotNullParameter((Object)la, (String)"la");
        Intrinsics.checkNotNullParameter((Object)lo, (String)"lo");
        Intrinsics.checkNotNullParameter((Object)al, (String)"al");
        Intrinsics.checkNotNullParameter((Object)md, (String)"md");
        this$0.saveGpsToPrefs(la, lo, al, md);
        return Unit.INSTANCE;
    }

    private static final Unit start$lambda$9$lambda$7$lambda$3(GpsWebViewHelper this$0, String $hostKey, String la, String lo, String al, String md) {
        Intrinsics.checkNotNullParameter((Object)la, (String)"la");
        Intrinsics.checkNotNullParameter((Object)lo, (String)"lo");
        Intrinsics.checkNotNullParameter((Object)al, (String)"al");
        Intrinsics.checkNotNullParameter((Object)md, (String)"md");
        this$0.saveGpsToPrefsForHost($hostKey, la, lo, al, md);
        return Unit.INSTANCE;
    }

    private static final Unit start$lambda$9$lambda$7$lambda$4(GpsWebViewHelper this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.onLog.invoke((Object)it);
        return Unit.INSTANCE;
    }

    private static final Unit start$lambda$9$lambda$7$lambda$5(GpsWebViewHelper this$0, String la, String lo, String al, String md) {
        Intrinsics.checkNotNullParameter((Object)la, (String)"la");
        Intrinsics.checkNotNullParameter((Object)lo, (String)"lo");
        Intrinsics.checkNotNullParameter((Object)al, (String)"al");
        Intrinsics.checkNotNullParameter((Object)md, (String)"md");
        GpsStore.INSTANCE.update(new GpsData(la, lo, al, md, 0L, 16, null));
        this$0.onGps.invoke((Object)la, (Object)lo, (Object)al, (Object)md);
        return Unit.INSTANCE;
    }

    private static final Unit start$lambda$9$lambda$7$lambda$6(GpsWebViewHelper this$0) {
        this$0.internalStop(true);
        return Unit.INSTANCE;
    }

    private static final void start$lambda$9$lambda$8(GpsWebViewHelper this$0) {
        this$0.internalStop(true);
    }

    /*
     * WARNING - void declaration
     */
    private static final void start$lambda$9(GpsWebViewHelper this$0, String $baseUrl, long $watchMillis, String $hostKey) {
        void $this$start_u24lambda_u249_u24lambda_u247;
        WebView webView;
        this$0.internalStop(true);
        WebView webView2 = webView = new WebView(this$0.context.getApplicationContext());
        GpsWebViewHelper gpsWebViewHelper = this$0;
        boolean bl = false;
        $this$start_u24lambda_u249_u24lambda_u247.setVisibility(8);
        $this$start_u24lambda_u249_u24lambda_u247.getSettings().setJavaScriptEnabled(true);
        $this$start_u24lambda_u249_u24lambda_u247.getSettings().setDomStorageEnabled(true);
        GpsJsBridge bridge = new GpsJsBridge($hostKey, (Function4<? super String, ? super String, ? super String, ? super String, Unit>)((Function4)(arg_0, arg_1, arg_2, arg_3) -> GpsWebViewHelper.start$lambda$9$lambda$7$lambda$2(this$0, arg_0, arg_1, arg_2, arg_3)), (Function4<? super String, ? super String, ? super String, ? super String, Unit>)((Function4)(arg_0, arg_1, arg_2, arg_3) -> GpsWebViewHelper.start$lambda$9$lambda$7$lambda$3(this$0, $hostKey, arg_0, arg_1, arg_2, arg_3)), (Function1<? super String, Unit>)((Function1)arg_0 -> GpsWebViewHelper.start$lambda$9$lambda$7$lambda$4(this$0, arg_0)), (Function4<? super String, ? super String, ? super String, ? super String, Unit>)((Function4)(arg_0, arg_1, arg_2, arg_3) -> GpsWebViewHelper.start$lambda$9$lambda$7$lambda$5(this$0, arg_0, arg_1, arg_2, arg_3)), (Function0<Unit>)((Function0)() -> GpsWebViewHelper.start$lambda$9$lambda$7$lambda$6(this$0)));
        $this$start_u24lambda_u249_u24lambda_u247.addJavascriptInterface((Object)bridge, "Android");
        $this$start_u24lambda_u249_u24lambda_u247.setWebViewClient(new WebViewClient((WebView)$this$start_u24lambda_u249_u24lambda_u247, this$0, $watchMillis){
            final /* synthetic */ WebView $this_apply;
            final /* synthetic */ GpsWebViewHelper this$0;
            final /* synthetic */ long $watchMillis;
            {
                this.$this_apply = $receiver;
                this.this$0 = $receiver2;
                this.$watchMillis = $watchMillis;
            }

            public void onPageFinished(WebView view, String url) {
                Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                this.$this_apply.evaluateJavascript(GpsWebViewHelper.access$buildInjectedJs(this.this$0, this.$watchMillis), null);
            }

            public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
                Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            }
        });
        gpsWebViewHelper.webView = webView;
        WebView webView3 = this$0.webView;
        if (webView3 != null) {
            webView3.loadUrl($baseUrl);
        }
        this$0.mainHandler.postDelayed(() -> GpsWebViewHelper.start$lambda$9$lambda$8(this$0), $watchMillis + 2000L);
    }

    private static final void stop$lambda$10(GpsWebViewHelper this$0) {
        this$0.internalStop(true);
    }

    public static final /* synthetic */ String access$buildInjectedJs(GpsWebViewHelper $this, long watchMillis) {
        return $this.buildInjectedJs(watchMillis);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u000b\b\u0002\u0018\u00002\u00020\u0001B\u00a3\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012$\u0010\u0004\u001a \u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005\u0012$\u0010\u0007\u001a \u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\t\u0012$\u0010\n\u001a \u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0003H\u0002J\u0010\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0003H\u0002J0\u0010\u0017\u001a\u00020\u00062\b\u0010\u0018\u001a\u0004\u0018\u00010\u00032\b\u0010\u0019\u001a\u0004\u0018\u00010\u00032\b\u0010\u001a\u001a\u0004\u0018\u00010\u00032\b\u0010\u001b\u001a\u0004\u0018\u00010\u0003H\u0007J\u001c\u0010\u001c\u001a\u00020\u00062\b\u0010\u0018\u001a\u0004\u0018\u00010\u00032\b\u0010\u0019\u001a\u0004\u0018\u00010\u0003H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\u0004\u001a \u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\u0007\u001a \u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\n\u001a \u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/fmdxconnector/GpsWebViewHelper$GpsJsBridge;", "", "hostKey", "", "saveGlobal", "Lkotlin/Function4;", "", "saveForHost", "onLog", "Lkotlin/Function1;", "onGpsCallback", "stopWebView", "Lkotlin/Function0;", "<init>", "(Ljava/lang/String;Lkotlin/jvm/functions/Function4;Lkotlin/jvm/functions/Function4;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function4;Lkotlin/jvm/functions/Function0;)V", "noGpsLogged", "", "lastGpsLogMs", "", "LOG_INTERVAL_MS", "round6", "value", "round1", "onGps", "lat", "lon", "alt", "mode", "onNoGps", "app_productionNoDebug"})
    @SourceDebugExtension(value={"SMAP\nGpsWebViewHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GpsWebViewHelper.kt\ncom/fmdxconnector/GpsWebViewHelper$GpsJsBridge\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,313:1\n1#2:314\n*E\n"})
    private static final class GpsJsBridge {
        @NotNull
        private final String hostKey;
        @NotNull
        private final Function4<String, String, String, String, Unit> saveGlobal;
        @NotNull
        private final Function4<String, String, String, String, Unit> saveForHost;
        @NotNull
        private final Function1<String, Unit> onLog;
        @NotNull
        private final Function4<String, String, String, String, Unit> onGpsCallback;
        @NotNull
        private final Function0<Unit> stopWebView;
        private volatile boolean noGpsLogged;
        private volatile long lastGpsLogMs;
        private final long LOG_INTERVAL_MS;

        public GpsJsBridge(@NotNull String hostKey, @NotNull Function4<? super String, ? super String, ? super String, ? super String, Unit> saveGlobal, @NotNull Function4<? super String, ? super String, ? super String, ? super String, Unit> saveForHost, @NotNull Function1<? super String, Unit> onLog, @NotNull Function4<? super String, ? super String, ? super String, ? super String, Unit> onGpsCallback, @NotNull Function0<Unit> stopWebView) {
            Intrinsics.checkNotNullParameter((Object)hostKey, (String)"hostKey");
            Intrinsics.checkNotNullParameter(saveGlobal, (String)"saveGlobal");
            Intrinsics.checkNotNullParameter(saveForHost, (String)"saveForHost");
            Intrinsics.checkNotNullParameter(onLog, (String)"onLog");
            Intrinsics.checkNotNullParameter(onGpsCallback, (String)"onGpsCallback");
            Intrinsics.checkNotNullParameter(stopWebView, (String)"stopWebView");
            this.hostKey = hostKey;
            this.saveGlobal = saveGlobal;
            this.saveForHost = saveForHost;
            this.onLog = onLog;
            this.onGpsCallback = onGpsCallback;
            this.stopWebView = stopWebView;
            this.LOG_INTERVAL_MS = 15000L;
        }

        private final String round6(String value) {
            Object object;
            block3: {
                block2: {
                    object = StringsKt.toDoubleOrNull((String)value);
                    if (object == null) break block2;
                    double it = ((Number)object).doubleValue();
                    boolean bl = false;
                    Locale locale = Locale.US;
                    String string2 = "%.6f";
                    Object[] objectArray = new Object[]{it};
                    String string3 = String.format(locale, string2, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
                    object = string3;
                    if (string3 != null) break block3;
                }
                object = value;
            }
            return object;
        }

        private final String round1(String value) {
            Object object;
            block3: {
                block2: {
                    object = StringsKt.toDoubleOrNull((String)value);
                    if (object == null) break block2;
                    double it = ((Number)object).doubleValue();
                    boolean bl = false;
                    Locale locale = Locale.US;
                    String string2 = "%.1f";
                    Object[] objectArray = new Object[]{it};
                    String string3 = String.format(locale, string2, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
                    object = string3;
                    if (string3 != null) break block3;
                }
                object = value;
            }
            return object;
        }

        @JavascriptInterface
        public final void onGps(@Nullable String lat, @Nullable String lon, @Nullable String alt, @Nullable String mode) {
            CharSequence charSequence;
            CharSequence charSequence22;
            CharSequence charSequence3;
            CharSequence charSequence4;
            String string2 = lat;
            String string3 = string2 != null ? ((Object)StringsKt.trim((CharSequence)string2)).toString() : null;
            if (string3 == null) {
                string3 = "";
            }
            String la = this.round6(string3);
            String string4 = lon;
            String string5 = string4 != null ? ((Object)StringsKt.trim((CharSequence)string4)).toString() : null;
            if (string5 == null) {
                string5 = "";
            }
            String lo = this.round6(string5);
            GpsJsBridge gpsJsBridge = this;
            String string6 = alt;
            if (string6 == null) {
                string6 = "";
            }
            if ((charSequence4 = (CharSequence)((Object)StringsKt.trim((CharSequence)string6)).toString()).length() == 0) {
                GpsJsBridge gpsJsBridge2 = gpsJsBridge;
                boolean charSequence22 = false;
                charSequence3 = "0";
                gpsJsBridge = gpsJsBridge2;
            } else {
                charSequence3 = charSequence4;
            }
            String al = gpsJsBridge.round1((String)charSequence3);
            String string7 = mode;
            if (string7 == null) {
                string7 = "";
            }
            if ((charSequence22 = (CharSequence)((Object)StringsKt.trim((CharSequence)string7)).toString()).length() == 0) {
                boolean bl = false;
                charSequence = "2";
            } else {
                charSequence = charSequence22;
            }
            String md = (String)charSequence;
            long now = SystemClock.elapsedRealtime();
            if (this.lastGpsLogMs == 0L || now - this.lastGpsLogMs >= this.LOG_INTERVAL_MS) {
                this.lastGpsLogMs = now;
            }
            this.saveGlobal.invoke((Object)la, (Object)lo, (Object)al, (Object)md);
            this.saveForHost.invoke((Object)la, (Object)lo, (Object)al, (Object)md);
            this.onGpsCallback.invoke((Object)la, (Object)lo, (Object)al, (Object)md);
            this.stopWebView.invoke();
        }

        @JavascriptInterface
        public final void onNoGps(@Nullable String lat, @Nullable String lon) {
            if (this.noGpsLogged) {
                return;
            }
            this.noGpsLogged = true;
            String string2 = lat;
            String string3 = string2 != null ? ((Object)StringsKt.trim((CharSequence)string2)).toString() : null;
            if (string3 == null) {
                string3 = "";
            }
            String la = this.round6(string3);
            String string4 = lon;
            String string5 = string4 != null ? ((Object)StringsKt.trim((CharSequence)string4)).toString() : null;
            if (string5 == null) {
                string5 = "";
            }
            String lo = this.round6(string5);
            String al = "0";
            String md = "2";
            this.saveGlobal.invoke((Object)la, (Object)lo, (Object)al, (Object)md);
            this.saveForHost.invoke((Object)la, (Object)lo, (Object)al, (Object)md);
            this.onGpsCallback.invoke((Object)la, (Object)lo, (Object)al, (Object)md);
        }
    }
}

