/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.lint;

import androidx.compose.lint.Names;
import androidx.compose.lint.PsiUtilsKt;
import androidx.compose.ui.lint.ModifierDeclarationDetectorKt;
import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.uast.UMethod;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u00012\u00020\u0002:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0014\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\tH\u0016\u00a8\u0006\r"}, d2={"Landroidx/compose/ui/lint/ModifierDeclarationDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "getApplicableUastTypes", "", "Ljava/lang/Class;", "Lorg/jetbrains/uast/UMethod;", "Companion", "ui-lint"})
public final class ModifierDeclarationDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Issue ModifierFactoryReturnType = Issue.Companion.create("ModifierFactoryReturnType", "Modifier factory functions should return Modifier", "Modifier factory functions should return Modifier as their type, and not a subtype of Modifier (such as Modifier.Element).", Category.CORRECTNESS, 3, Severity.WARNING, new Implementation(ModifierDeclarationDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE, (Enum)Scope.TEST_SOURCES)));
    @NotNull
    private static final Issue ModifierFactoryExtensionFunction = Issue.Companion.create("ModifierFactoryExtensionFunction", "Modifier factory functions should be extensions on Modifier", "Modifier factory functions should be defined as extension functions on Modifier to allow modifiers to be fluently chained.", Category.CORRECTNESS, 3, Severity.WARNING, new Implementation(ModifierDeclarationDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE, (Enum)Scope.TEST_SOURCES)));
    @NotNull
    private static final Issue ModifierFactoryUnreferencedReceiver = Issue.Companion.create("ModifierFactoryUnreferencedReceiver", "Modifier factory functions must use the receiver Modifier instance", "Modifier factory functions are fluently chained to construct a chain of Modifier objects that will be applied to a layout. As a result, each factory function *must* use the receiver `Modifier` parameter, to ensure that the function is returning a chain that includes previous items in the chain. Make sure the returned chain either explicitly includes `this`, such as `return this.then(MyModifier)` or implicitly by returning a chain that starts with an implicit call to another factory function, such as `return myModifier()`, where `myModifier` is defined as `fun Modifier.myModifier(): Modifier`.", Category.CORRECTNESS, 3, Severity.ERROR, new Implementation(ModifierDeclarationDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE, (Enum)Scope.TEST_SOURCES)));

    @NotNull
    public List<Class<UMethod>> getApplicableUastTypes() {
        return CollectionsKt.listOf(UMethod.class);
    }

    @NotNull
    public UElementHandler createUastHandler(@NotNull JavaContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new UElementHandler(context){
            final /* synthetic */ JavaContext $context;
            {
                this.$context = $context;
            }

            public void visitMethod(@NotNull UMethod node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                PsiType psiType = node.getReturnType();
                if (psiType == null) {
                    return;
                }
                PsiType returnType = psiType;
                if (!PsiUtilsKt.inheritsFrom(returnType, Names.Ui.INSTANCE.getModifier())) {
                    return;
                }
                if (PsiUtilsKt.inheritsFrom(returnType, Names.Ui.Layout.INSTANCE.getParentDataModifier())) {
                    return;
                }
                PsiElement source = node.getSourcePsi();
                if (source instanceof KtParameter) {
                    return;
                }
                if (source instanceof KtProperty) {
                    if (KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)source)) != null) {
                        return;
                    }
                    if (((KtProperty)source).isVar()) {
                        return;
                    }
                    if (((KtProperty)source).getGetter() == null) {
                        return;
                    }
                }
                if (source instanceof KtPropertyAccessor) {
                    KtProperty ktProperty = ((KtPropertyAccessor)source).getProperty();
                    Intrinsics.checkNotNullExpressionValue((Object)ktProperty, (String)"source.property");
                    if (KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)ktProperty)) != null) {
                        return;
                    }
                    if (((KtPropertyAccessor)source).getProperty().isVar()) {
                        return;
                    }
                }
                ModifierDeclarationDetectorKt.access$checkReturnType(node, this.$context, returnType);
                ModifierDeclarationDetectorKt.access$checkReceiver(node, this.$context);
            }
        };
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006\u00a8\u0006\u000b"}, d2={"Landroidx/compose/ui/lint/ModifierDeclarationDetector$Companion;", "", "()V", "ModifierFactoryExtensionFunction", "Lcom/android/tools/lint/detector/api/Issue;", "getModifierFactoryExtensionFunction", "()Lcom/android/tools/lint/detector/api/Issue;", "ModifierFactoryReturnType", "getModifierFactoryReturnType", "ModifierFactoryUnreferencedReceiver", "getModifierFactoryUnreferencedReceiver", "ui-lint"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Issue getModifierFactoryReturnType() {
            return ModifierFactoryReturnType;
        }

        @NotNull
        public final Issue getModifierFactoryExtensionFunction() {
            return ModifierFactoryExtensionFunction;
        }

        @NotNull
        public final Issue getModifierFactoryUnreferencedReceiver() {
            return ModifierFactoryUnreferencedReceiver;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

